/*
SAMO JEDNA TRAKA
2 SMERA 
~  VOZILO SE KRECE AKO IZ SUPROTNOG SMERA NEMA NIKOGA
NEMA OGRANICENJA VOZILA ~
~~ SAMO JEDAN AUTOBUS ~~
## KAMION MORA BITI JEDINO VOZILO NA PUTU ###

*ULAZAK VOZILA JE RAND VREME I NE BLOKIRAJU DOK CEKAJU
*/

#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>

#define RAND_MODUL 3 // modul za vreme (tj. max broj sekundi)

#define N 10 // kola
#define M 10  // autobus
#define K 2 // kamion 

int smer = 0; // smer =1 sever , smer = 2 jug
int br_vozila = 0;

int autobus_flag =0;
int kamion_flag = 0;

pthread_mutex_t put_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t bus_kond = PTHREAD_COND_INITIALIZER;
pthread_cond_t kamion_kond = PTHREAD_COND_INITIALIZER;
pthread_cond_t smer_kond = PTHREAD_COND_INITIALIZER;

void *funkcija_jug(void *arg)
{
    int id_vozila = *(int *)arg; // 1 kola, 2 bus, 3 kamion
    pthread_mutex_lock(&put_mutex);

    while(smer == 1 || kamion_flag) 
    {
        pthread_cond_wait(&smer_kond,&put_mutex);
    }
    
    
    smer = 2;
    int vreme = rand()%RAND_MODUL;
    if(id_vozila==2)
    {
        while(autobus_flag || kamion_flag || smer==1)
        {
            pthread_cond_wait(&bus_kond,&put_mutex);
        }
        smer = 2;
        printf("NIT autobus ulazi sa JUGA \n");
        br_vozila++;
        autobus_flag =1 ;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT autobus izlazi sa JUGA \n");
        
        autobus_flag =0 ;
        pthread_cond_broadcast(&bus_kond);
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&kamion_kond);// saljemo i kamionu jer je broj vozila 0
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    else if(id_vozila==3)
    {
        while(kamion_flag || br_vozila>0)
        {
            pthread_cond_wait(&kamion_kond,&put_mutex);
        }
        printf("NIT kamion ulazi sa JUGA \n");
        br_vozila++;
        kamion_flag = 1;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT kamion izlazi sa JUGA \n");
        
        kamion_flag = 0;
        pthread_cond_broadcast(&kamion_kond);
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    else if(id_vozila == 1)
    {
        printf("NIT automobil ulazi sa JUGA \n");
        br_vozila++;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT automobil izlazi sa JUGA \n");
        
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&kamion_kond);// saljemo i kamionu jer je broj vozila 0
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    

    pthread_exit(NULL);
}

void *funkcija_sever(void *arg)
{
    int id_vozila = *(int *)arg; // 1 kola, 2 bus, 3 kamion
    pthread_mutex_lock(&put_mutex);

    while(smer == 2 || kamion_flag)
    {
        pthread_cond_wait(&smer_kond,&put_mutex);
    }
    
    smer = 1;
    int vreme = rand()%RAND_MODUL;
    if(id_vozila==2)
    {
        while(autobus_flag ||  kamion_flag || smer == 2)
        {
            pthread_cond_wait(&bus_kond,&put_mutex);
        }
        smer = 1;
        printf("NIT autobus ulazi sa SEVERA \n");
        br_vozila++;
        autobus_flag =1 ;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT autobus izlazi sa SEVERA \n");
        autobus_flag =0 ;
        pthread_cond_broadcast(&bus_kond);
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&kamion_kond);// saljemo i kamionu jer je broj vozila 0
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    else if(id_vozila==3)
    {
        while(kamion_flag || br_vozila>0)
        {
            pthread_cond_wait(&kamion_kond,&put_mutex);
        }
        printf("NIT kamion ulazi sa SEVERA \n");
        br_vozila++;
        kamion_flag = 1;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT kamion izlazi sa SEVERA \n");
        
        kamion_flag = 0;
        pthread_cond_broadcast(&kamion_kond);
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    else if(id_vozila == 1)
    {
        printf("NIT automobil ulazi sa SEVERA \n");
        br_vozila++;
        pthread_mutex_unlock(&put_mutex);
        
        sleep(vreme); 
        pthread_mutex_lock(&put_mutex);
        br_vozila--;
        printf("NIT automobil izlazi sa SEVERA \n");
        
        
        if(br_vozila == 0)
        {
            smer = 0;
            pthread_cond_broadcast(&smer_kond);
            pthread_cond_broadcast(&kamion_kond);// saljemo i kamionu jer je broj vozila 0
            pthread_cond_broadcast(&bus_kond);// saljemo i busu jer moze da promeni smer //temp
        }
        
        pthread_mutex_unlock(&put_mutex);
        pthread_exit(NULL);
    }
    
    pthread_exit(NULL);
}


int main()
{
    pthread_t automobil[N];
    pthread_t autobus[M];
    pthread_t kamion[K];

    long pom1 = 1; // kola
    long pom2 = 2; // bus
    long pom3 = 3; // kamion
    
    //create jug
    for(int i =0 ; i<N/2;i++)
    {
        pthread_create(&automobil[i],NULL,funkcija_jug,&pom1);
    }
    for(int i =0 ; i<M/2;i++)
    {
        pthread_create(&autobus[i],NULL,funkcija_jug,&pom2);
        
    }
    for(int i =0 ; i<K/2;i++)
    {
        pthread_create(&kamion[i],NULL,funkcija_jug,&pom3);
        
    }
    //create sever
    for(int i =N/2 ; i<N;i++)
    {
        pthread_create(&automobil[i],NULL,funkcija_sever,&pom1);
    }
    for(int i =M/2 ; i<M;i++)
    {
        pthread_create(&autobus[i],NULL,funkcija_sever,&pom2);
        
    }
    for(int i =K/2 ; i<K;i++)
    {
        pthread_create(&kamion[i],NULL,funkcija_sever,&pom3);
        
    }

    //join
    for(int i =0 ; i<N;i++)
    {
        pthread_join(automobil[i],NULL);
    }
    for(int i =0 ; i<M;i++)
    {
        pthread_join(autobus[i],NULL);
        
    }
    for(int i =0 ; i<K;i++)
    {
        pthread_join(kamion[i],NULL);
        
    }
    printf("MAIN - KRAJ\n");


    return 0;
}
